<!--
The MIT License

Copyright (c) 2016-2019 The Dashboard Team, https://www.the-dashboard.ch/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

Note that components used by and bundled with this software might have
different license terms. See LICENSE file for details.

Environment: none
-->

<!DOCTYPE html>
<html lang="en" ng-app="dashboardApp">
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta charset="UTF-8">
    <title>The Dashboard</title>

    <script type="text/javascript">
        // SET THESE URLS TO POINT TO YOUR SHAREPOINT INSTANCE
        window.dashboardSharePointBaseUrl = '<GIVE THE FULL URL OF YOUR SHAREPOINT HERE WITH TRAILING SLASH>';
        window.dashboardSharePointApiBaseUrl = window.dashboardSharePointBaseUrl + '_api/';
        
        // SET THIS TO TRUE IF THIS IS YOUR TEST INSTANCE OR FALSE IF THIS IS YOUR
        // PRODUCTIVE INSTANCE
        window.dashboardTestEnvironment = false;

        // IF YOU WANT TO SET A CUSTOM COLOR PALETTE FOR YOUR CHARTS, YOU CAN SPECIFY
        // AN ARRAY OF COLORS IN RGB FORMAT HERE:
        // window.dashboardCustomColors = ['#000000', '#FFFFFF'];

        // IF YOUR SHAREPOINT USES A CUSTOM LISTVIEWTHRESHOLD (INSTEAD OF THE DEFAULT
        // 5000 ITEMS), YOU CAN SPECIFY THIS HERE - HELPS WITH LARGE LISTS
        window.dashboardSharePointListViewThreshold = 5000;
    </script>

    <link rel="stylesheet" href="styles/bootstrap.96921.css">

    <link rel="stylesheet" href="styles/ng-tags-input.0387e.css">

    <link rel="stylesheet" href="styles/text-angular.f449f.css">

    <link rel="stylesheet" href="styles/ng-dialog.c5fa3.css">

    <link rel="stylesheet" href="styles/ng-dialog-theme.04007.css">

    <link rel="stylesheet" href="styles/font-awesome.045a6.css">

    <link rel="stylesheet" href="styles/angular-ui-tree.d59b9.css">

    <link rel="stylesheet" href="styles/angular-bootstrap-datetimepicker.4a6fd.css">

    <link rel="stylesheet" href="styles/angular-ui-grid.fcaad.css">

    <link rel="stylesheet" href="styles/tribute.14c5b.css">

    <link rel="stylesheet" href="styles/main.0fd22.css">

    <link rel="stylesheet" href="styles/charts.eb567.css">
</head>
<body>

<div id="mainNavbar" ng-controller="navbarController" ng-class="{ 'dashboardNavbar': true, 'dashboardNavbarTesting': isTestingMode }">
    <ul style="float:left; list-style-type:none;">
        <li ui-sref-active="active"><a ui-sref="index" translate>Home</a></li>
        <li ui-sref-active="active"><a ui-sref="tree" translate>Ongoing Risk Assessment</a></li>
        <li ui-sref-active="active"><a ui-sref="tasks" translate>Ongoing Control Assessment</a></li>
        <li ui-sref-active="active"><a ui-sref="reports" translate>Ad-hoc-Reporting</a></li>
    </ul>

    <ul style="float:right; list-style-type:none;">
        <li class="testing-indicator"><b>[ TESTING ]</b></li>
        <li ui-sref-active="active" ng-show="isAdmin"><a ui-sref="admin" translate>Administration</a></li>
        <li ui-sref-active="active"><a ui-sref="profile" translate>Profile</a></li>
        <li ui-sref-active="active"><a ui-sref="about" translate>About</a></li>
        <li><i title="{{ 'Give feedback' | translate }}" class="fa fa-comment feedback-icon icon-as-button" ng-click="startFeedback()"></i></li>
    </ul>
</div>

<div id="mainSidebar" ng-controller="sidebarController" ng-class="['dashboardSidebar', sidebarVisibility]">
    <ng-include src="sidebarTemplate"></ng-include>
</div>

<div ui-view="main" ng-controller="mainDivController" ng-style="mainDivStyle"></div>


<script src="scripts/main.c8928.js"></script>


<!-- ONLY ENABLE THIS IF YOU WANT TO LOG USAGE ACTIVITY (E.G. FOR RESEARCH ACTIVITY)      -->
<!-- REQUIRES THE 80002-usage-logging.js LOADFILE TO BE LOADED AND REQUIRES USER CONSENT  -->
<!--
<script type="text/javascript">
  angular.module('dashboardApp')
    .controller('dashboardUsageLoggingCtrl', [ '$scope', '$location', 'restListService', 'usersService', function($scope, $location, restListService, usersService) {
      console.log('Initializing dashboardUsageLogging...');

      var optoutUsers = [ ];

      $scope.$on('$locationChangeSuccess', function() {
        var newPath = $location.url();

        console.log('dashboardUsageLogging triggered on ' + newPath + '.');

        usersService
          .getCurrentUser()
          .then(
            function(user) {
              if(optoutUsers.indexOf(user.id.toString()) === -1) {
                  restListService.addItem(undefined, {
                    Title: newPath
                  }, 'Dashboard - Usage');
              } else {
                console.log('dashboardUsageLogging prevented as user is listed as opt-out.');
              }
            }
          );

      });
    }]);
</script>
<div ng-controller="dashboardUsageLoggingCtrl"></div>
-->
<!-- ONLY ENABLE THIS IF YOU WANT TO LOG USAGE ACTIVITY (E.G. FOR RESEARCH ACTIVITY)      -->

</body>
</html>
